/*
 * @(#)CERGeneralizationConnector.java  1.0  21. M�rz 2006
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.cer.diagram;


import java.awt.geom.*;
import java.awt.*;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.DecoratedFigure;
import org.jhotdraw.draw.connector.AbstractConnector;
import org.jhotdraw.geom.Geom;
/**
 * CERGeneralizationConnector.
 * 
 * 
 * @author Werner Randelshofer
 * @version 1.0 21. Maerz 2006 Created.
 */
public class CERGeneralizationConnector extends AbstractConnector {
    
    /** Creates a new instance. */
    public CERGeneralizationConnector() {
    }
    public CERGeneralizationConnector(CERISAFigure owner) {
        super(owner);
    }
    
    /**
     * Tests if a point is contained in the connector.
     */
    @Override
    public boolean contains(Point2D.Double p) {
        Rectangle2D.Double r = getBounds();
        return getOwner().contains(p) && p.y > r.y + r.height / 2;
    }
    
    @Override
    public Rectangle2D.Double getBounds() {
        return ((DecoratedFigure) getOwner()).getDecorator().getBounds();
    }
    @Override
    public Point2D.Double getAnchor() {
        Rectangle2D.Double r = getBounds();
        double grow = AttributeKeys.getStrokeTotalWidth(((DecoratedFigure) getOwner()).getDecorator());
        
        double dx = r.width / 2d;
        double dy = r.height;
        double lineLength = Math.sqrt(dx * dx + dy * dy);
        double scale = grow /  lineLength;
        double ddx = scale * dy;
        double ddy = scale * dx;
        Point2D.Double intersectH = Geom.intersect(r.x-ddx, r.y+ddy, r.x + r.width / 2-ddx, r.y + r.height+ddy, r.x, r.y - grow, r.x + r.width, r.y - grow, r.width * r.height);
        Point2D.Double intersectV = Geom.intersect(r.x-ddx, r.y+ddy, r.x + r.width / 2-ddx, r.y + r.height+ddy, r.x + r.width / 2, r.y, r.x + r.width / 2, r.y + r.height, r.width * r.height);
        if (intersectH != null) {
            
            r.width += (r.x - intersectH.x) * 2;
            r.x = intersectH.x;
        }
        if (intersectV != null) {
            r.height += grow + intersectV.y - r.y - r.height;
            r.y -= grow;
        }
        
        
        return new Point2D.Double(r.x + r.width / 2, r.y + r.height);
    }
  @Override protected Point2D.Double findPoint(ConnectionFigure connection) {
        return getAnchor();
        /*
        Rectangle2D.Double r = getBounds();
        return new Point2D.Double(r.x + r.width / 2, r.y + r.height / 2);
         */
    }
    @Override
    public void draw(Graphics2D g) {
        //Rectangle2D.Double bounds = getBounds();
        Point2D.Double p = getAnchor();
        Ellipse2D.Double circle = new Ellipse2D.Double(p.x - 3, p.y - 3, 6, 6);
        g.setColor(Color.blue);
        g.fill(circle);
    }
}
